# PLIS Discord Bot

Discord bot for MinersUniverse PLIS (Player Information System) - handles role management, moderation, and server integration.

## Setup

### 1. Create Discord Bot
1. Go to https://discord.com/developers/applications
2. Click "New Application" and give it a name
3. Go to the "Bot" tab → "Add Bot"
4. Copy the Bot Token (you'll need this)
5. Enable these Privileged Gateway Intents:
   - ✅ Server Members Intent
   - ✅ Presence Intent (optional)
   - ❌ Message Content Intent (not needed)

### 2. Invite Bot to Server
1. Go to OAuth2 → URL Generator
2. Select scopes:
   - ✅ bot
   - ✅ applications.commands
3. Select bot permissions:
   - ✅ Manage Roles
   - ✅ Kick Members
   - ✅ Ban Members
   - ✅ Moderate Members (Timeout)
   - ✅ Move Members
   - ✅ View Channels
   - ✅ Send Messages
4. Copy the generated URL and open it in your browser
5. Select your server and authorize

### 3. Get Guild ID
1. In Discord, enable Developer Mode (User Settings → Advanced → Developer Mode)
2. Right-click your server icon → Copy ID
3. Save this Guild ID

### 4. Configure Bot
1. Copy `.env.example` to `.env`:
   ```bash
   cp .env.example .env
   ```
2. Edit `.env` and fill in:
   ```
   DISCORD_TOKEN=your_bot_token_here
   GUILD_ID=your_guild_id_here
   ```

### 5. Install Dependencies
```bash
npm install
```

### 6. Run the Bot
```bash
npm start
```

You should see:
```
[INFO] ✅ Bot ready! Logged in as YourBot#1234
[INFO] Guild ID: 123456789012345678
[INFO] ✅ Connected to guild: YourServerName
```

## Important Notes

### Role Hierarchy
- The bot's role MUST be positioned ABOVE any roles it needs to manage
- In Discord Server Settings → Roles, drag the bot's role higher than managed roles
- Otherwise, role operations will fail with "Missing Permissions"

### PLIS Integration
- The bot runs independently but PLIS PHP backend calls Discord REST API directly
- This bot provides:
  - Presence/online status
  - Event logging (member join/leave, role changes)
  - Future: slash commands, moderation actions
- PLIS handles role management via REST API using the same bot token

### Security
- Keep `.env` file secret (never commit to git)
- Add `.env` to `.gitignore`
- Rotate bot token if exposed (Discord Developer Portal → Bot → Reset Token)

## Running in Production

### Using PM2 (recommended)
```bash
npm install -g pm2
pm2 start index.js --name plis-bot
pm2 save
pm2 startup
```

### Using systemd (Linux)
Create `/etc/systemd/system/plis-bot.service`:
```ini
[Unit]
Description=PLIS Discord Bot
After=network.target

[Service]
Type=simple
User=youruser
WorkingDirectory=/path/to/plis/npm
ExecStart=/usr/bin/node index.js
Restart=always
RestartSec=10

[Install]
WantedBy=multi-user.target
```

Then:
```bash
sudo systemctl enable plis-bot
sudo systemctl start plis-bot
sudo systemctl status plis-bot
```

## Logs
- Default log level: `info`
- Change in `.env`: `LOG_LEVEL=debug` for verbose output
- Levels: `debug`, `info`, `warn`, `error`

## Troubleshooting

### Bot not connecting
- Check `DISCORD_TOKEN` is correct
- Verify bot is invited to the server
- Check `GUILD_ID` matches your server

### Role operations failing
- Ensure bot role is positioned above managed roles
- Verify "Manage Roles" permission is granted
- Check bot has access to the channel/member

### Member events not firing
- Enable "Server Members Intent" in Discord Developer Portal
- Restart the bot after enabling intents

## Future Features
- Slash commands for moderation
- Announcement broadcasting
- Voice channel management
- Automated moderation rules
- Integration with PLIS case system
